# 画面設計書 43-kubectl options

## 概要

本ドキュメントは、kubectlのoptionsコマンドの画面設計書である。全kubectlコマンドに共通して継承されるグローバルフラグの一覧を標準出力に表示するCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：kubectlには全コマンドに共通するグローバルフラグ（--kubeconfig, --context, --namespace, --server, --token等）が多数存在する。optionsコマンドは、これらのフラグをまとめて確認するための参照用コマンドであり、特にkubeconfig関連のフラグを確認する際に有用である。

**画面へのアクセス方法**：ターミナルから `kubectl options` を実行する。

**主要な操作・処理内容**：
1. cobra.Commandの `Usage()` メソッドを呼び出し、継承されたフラグ一覧を表示する
2. `templates.UseOptionsTemplates(cmd)` により、オプション表示専用のテンプレートが適用される
3. 出力先を明示的に `out`（通常はstdout）に設定している（デフォルトではstderrにフォールバックするため）

**画面遷移**：CLIコマンドであるため画面遷移は存在しない。kubectlルートコマンドの「Other Commands」カテゴリに属する。

**権限による表示制御**：API Serverへのアクセスは行わないため、権限による制御は存在しない。ローカルで完結する処理である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | Config管理 | 補助機能 | 全コマンド共通のフラグ一覧を出力する（kubeconfig関連フラグを含む） |

## 画面種別

ヘルプ表示（CLIテキスト出力）

## URL/ルーティング

```
kubectl options
```

## 入出力項目

### 入力項目（フラグ）

本コマンド固有のフラグは存在しない。

### 出力項目

| 項目名 | 型 | 説明 |
|--------|------|------|
| フラグ名 | string | グローバルフラグの名前 |
| フラグ説明 | string | フラグの用途説明 |

## 表示項目

cobra.Commandの継承フラグが表示される。典型的な出力例：

```
The following options can be passed to any command:

      --as string                      Username to impersonate for the operation
      --kubeconfig string              Path to the kubeconfig file to use for CLI requests
  -n, --namespace string               If present, the namespace scope for this CLI request
      --context string                 The name of the kubeconfig context to use
      ...
```

## イベント仕様

### 1-コマンド実行

1. `cmd.Usage()` メソッドが呼ばれ、cobraが継承フラグを含むUsage情報を出力する
2. 出力先は `cmd.SetOut(out)` により明示的にstdoutに設定されている

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コマンド実行 | なし | なし | API Serverへのアクセスなし。ローカルで完結する |

## メッセージ仕様

エラーメッセージは発生しない（Usage表示は常に成功する）。

## 例外処理

本コマンドでは例外が発生するケースはほぼ存在しない。

## 備考

- 実装は非常にシンプルで、cobra.CommandのUsage機能をそのまま利用している
- `cmd.SetOut(out)` と `cmd.SetErr(out)` を明示的に呼ぶ理由は、cobraのデフォルトがstderrであるため（PR #46394参照）
- `templates.UseOptionsTemplates(cmd)` により、kubectlスタイルのヘルプテンプレートが適用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本コマンドにはオプション構造体は存在しない。cobraのCommand構造のみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | options.go | `staging/src/k8s.io/kubectl/pkg/cmd/options/options.go` | NewCmdOptions関数（行35-56）がすべてである。Run関数内で cmd.Usage() を呼ぶだけの最小実装 |

**主要処理フロー**:
1. **行36-44**: cobra.Commandの定義。Runで`cmd.Usage()`を呼ぶ
2. **行51-52**: 出力先をstdoutに設定（stderrではなく）
3. **行54**: オプション表示用テンプレートを適用

### プログラム呼び出し階層図

```
NewCmdOptions (options.go:35)
    |
    +-- cobra.Command.Run
           |
           +-- cmd.Usage()
                   +-- templates.UseOptionsTemplates()
```

### データフロー図

```
[入力]               [処理]                    [出力]

(なし) ──────> cobra.Command.Usage() ──────> stdout
               (テンプレート適用済み)          (フラグ一覧)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| options.go | `staging/src/k8s.io/kubectl/pkg/cmd/options/options.go` | ソース | optionsコマンド本体の実装 |
| templates.go | `staging/src/k8s.io/kubectl/pkg/util/templates/` | ソース | UseOptionsTemplatesの実装 |
